/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.bedrock;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.moulberry.axiom.bedrock.BedrockGeometry;
import com.moulberry.axiom.bedrock.BedrockModel;
import com.moulberry.axiom.bedrock.BedrockModelRegistry;
import com.moulberry.axiom.i18n.LoadedPackResources;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1921;
import net.minecraft.class_2259;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import org.joml.Vector3f;

public class BedrockPackLoader {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(BedrockGeometry.Cube.class, (Object)new BedrockGeometry.CubeDeserializer()).registerTypeAdapter(Vector3f.class, (Object)new BedrockGeometry.Vector3fDeserializer()).create();

    public static void loadFolder(Path root) {
        if (!Files.isDirectory(root, new LinkOption[0])) {
            BedrockPackLoader.sendError("Not a directory: " + String.valueOf(root));
            return;
        }
        BedrockPackLoader.sendSuccess("Loading Bedrock packs from " + String.valueOf(root) + "...");
        Path resourcePackDirectory = null;
        Path behaviourPackDirectory = null;
        try (Stream<Path> files = Files.walk(root, new FileVisitOption[0]);){
            Iterator iterator = files.iterator();
            while (iterator.hasNext()) {
                Path file = (Path)iterator.next();
                if (!file.getFileName().toString().equals("manifest.json")) continue;
                JsonObject jsonObject = (JsonObject)GSON.fromJson(Files.readString(file), JsonObject.class);
                JsonArray modules = jsonObject.getAsJsonArray("modules");
                if (modules == null) {
                    BedrockPackLoader.sendError("Missing 'modules' in manifest.json");
                    continue;
                }
                for (JsonElement module : modules) {
                    String type2 = module.getAsJsonObject().get("type").getAsString();
                    if (type2.equals("data")) {
                        behaviourPackDirectory = file.getParent();
                    }
                    if (!type2.equals("resources")) continue;
                    resourcePackDirectory = file.getParent();
                }
                if (resourcePackDirectory == null || behaviourPackDirectory == null) continue;
                break;
            }
        }
        catch (IOException e) {
            BedrockPackLoader.sendError(e.toString());
            return;
        }
        if (resourcePackDirectory == null) {
            BedrockPackLoader.sendError("Failed to find bedrock resource pack (missing manifest.json?)");
            return;
        }
        if (behaviourPackDirectory == null) {
            BedrockPackLoader.sendError("Failed to find bedrock behaviour pack (missing manifest.json?)");
            return;
        }
        BedrockPackLoader.sendSuccess("Found resource pack at " + String.valueOf(resourcePackDirectory) + ", loading...");
        BedrockPackLoader.sendSuccess("Found behaviour pack at " + String.valueOf(behaviourPackDirectory) + ", loading...");
        BedrockPackLoader.loadPacks(resourcePackDirectory, behaviourPackDirectory);
    }

    private static void loadPacks(Path resourcePackDirectory, Path behaviourPackDirectory) {
        Map<String, BedrockGeometry> geometryMap = BedrockPackLoader.loadGeometry(resourcePackDirectory);
        if (geometryMap == null) {
            return;
        }
        Map<String, byte[]> textureMap = BedrockPackLoader.loadTextures(resourcePackDirectory);
        if (textureMap == null) {
            return;
        }
        Path blocks = behaviourPackDirectory.resolve("blocks");
        ArrayList<JsonObject> customBlocks = new ArrayList<JsonObject>();
        try (Stream<Path> files = Files.walk(blocks, new FileVisitOption[0]);){
            Iterator<Object> iterator = files.iterator();
            while (iterator.hasNext()) {
                JsonObject jsonObject;
                Path path = (Path)iterator.next();
                if (!path.getFileName().toString().endsWith(".json") || !(jsonObject = (JsonObject)GSON.fromJson(Files.readString(path), JsonObject.class)).has("minecraft:block")) continue;
                customBlocks.add(jsonObject.getAsJsonObject("minecraft:block"));
            }
        }
        catch (IOException e) {
            BedrockPackLoader.sendError(e.toString());
            return;
        }
        if (customBlocks.isEmpty()) {
            BedrockPackLoader.sendError("Couldn't find any custom blocks in behaviour pack");
            return;
        }
        BedrockPackLoader.sendSuccess("Found " + customBlocks.size() + " custom block(s) in behaviour pack");
        record ModelData(BedrockModel bedrockModel, class_1921 renderType) {
        }
        HashMap<class_2680, ModelData> models = new HashMap<class_2680, ModelData>();
        for (JsonObject jsonObject : customBlocks) {
            class_1921 renderType;
            JsonObject description = jsonObject.getAsJsonObject("description");
            String identifier = description.get("identifier").getAsString();
            JsonObject axiomBedrock = jsonObject.getAsJsonObject("axiom:bedrock");
            if (axiomBedrock == null) {
                BedrockPackLoader.sendError("Skipping " + identifier + ", missing axiom:bedrock component");
                continue;
            }
            JsonObject components = jsonObject.getAsJsonObject("components");
            JsonElement jsonElement = components.get("minecraft:geometry");
            String geometryIdentifier = jsonElement.isJsonPrimitive() ? jsonElement.getAsString() : jsonElement.getAsJsonObject().get("identifier").getAsString();
            JsonObject materialInstances = components.getAsJsonObject("minecraft:material_instances");
            JsonObject baseMaterial = materialInstances.getAsJsonObject("*");
            String textureIdentifier = baseMaterial.get("texture").getAsString();
            String renderMethod = baseMaterial.has("render_method") ? baseMaterial.get("render_method").getAsString() : "opaque";
            ArrayList<class_2680> blockStates = new ArrayList<class_2680>();
            JsonArray axiomReplacementBlocks = axiomBedrock.getAsJsonArray("blocks");
            for (JsonElement axiomReplacementBlock : axiomReplacementBlocks) {
                try {
                    class_2259.class_7211 result = class_2259.method_41957((class_7225)class_7923.field_41175.method_46771(), (String)axiomReplacementBlock.getAsString(), (boolean)false);
                    blockStates.add(result.comp_622());
                }
                catch (Exception e) {
                    BedrockPackLoader.sendError("Skipping " + identifier + ", encountered invalid replacement " + axiomReplacementBlock.getAsString());
                }
            }
            BedrockGeometry geometry = geometryMap.get(geometryIdentifier);
            if (geometry == null) {
                BedrockPackLoader.sendError("Skipping " + identifier + ", missing geometry: " + geometryIdentifier);
                continue;
            }
            if (!textureMap.containsKey(textureIdentifier)) {
                BedrockPackLoader.sendError("Skipping " + identifier + ", missing geometry: " + geometryIdentifier);
                continue;
            }
            if (blockStates.isEmpty()) {
                BedrockPackLoader.sendError("Skipping " + identifier + ", not enough replacement blocks. Need 1, have " + blockStates.size());
                continue;
            }
            switch (renderMethod) {
                case "opaque": 
                case "double_sided": {
                    class_1921 class_19212 = class_1921.method_23577();
                    break;
                }
                case "alpha_test": {
                    class_1921 class_19212 = class_1921.method_23581();
                    break;
                }
                case "blend": {
                    class_1921 class_19212 = class_1921.method_23583();
                    break;
                }
                default: {
                    class_1921 class_19212 = renderType = null;
                }
            }
            if (renderType == null) {
                BedrockPackLoader.sendError("Skipping " + identifier + ", unknown render method " + renderMethod);
                continue;
            }
            boolean doubleSided = switch (renderMethod) {
                case "alpha_test", "double_sided" -> true;
                default -> false;
            };
            models.put((class_2680)blockStates.get(0), new ModelData(new BedrockModel(geometry, textureIdentifier, doubleSided), renderType));
        }
        BedrockModelRegistry.INSTANCE.clear();
        for (Map.Entry entry : models.entrySet()) {
            BedrockModelRegistry.INSTANCE.putModel((class_2680)entry.getKey(), ((ModelData)entry.getValue()).bedrockModel, ((ModelData)entry.getValue()).renderType());
        }
        HashMap<String, byte[]> namespacedTextures = new HashMap<String, byte[]>();
        for (Map.Entry<String, byte[]> entry : textureMap.entrySet()) {
            namespacedTextures.put("textures/block/bedrock_models/" + entry.getKey() + ".png", entry.getValue());
        }
        BedrockModelRegistry.INSTANCE.setResources(new LoadedPackResources("axiom_bedrock_models", (class_2561)class_2561.method_43470((String)"Bedrock Models (Axiom)"), namespacedTextures));
        class_310.method_1551().method_1521();
    }

    private static Map<String, BedrockGeometry> loadGeometry(Path resourcePackDirectory) {
        Path blockModels = resourcePackDirectory.resolve("models").resolve("blocks");
        HashMap<String, BedrockGeometry> geometryMap = new HashMap<String, BedrockGeometry>();
        try (Stream<Path> files = Files.walk(blockModels, new FileVisitOption[0]);){
            Iterator iterator = files.iterator();
            while (iterator.hasNext()) {
                JsonObject jsonObject;
                Path file = (Path)iterator.next();
                if (!file.getFileName().toString().endsWith(".json") || !(jsonObject = (JsonObject)GSON.fromJson(Files.readString(file), JsonObject.class)).has("minecraft:geometry")) continue;
                JsonArray geometryArray = jsonObject.getAsJsonArray("minecraft:geometry");
                for (JsonElement jsonElement : geometryArray) {
                    BedrockGeometry geometry = (BedrockGeometry)GSON.fromJson((JsonElement)jsonElement.getAsJsonObject(), BedrockGeometry.class);
                    geometryMap.put(geometry.description.identifier, geometry);
                }
            }
        }
        catch (IOException e) {
            BedrockPackLoader.sendError(e.toString());
            return null;
        }
        return geometryMap;
    }

    private static Map<String, byte[]> loadTextures(Path resourcePackDirectory) {
        Path textureDir = resourcePackDirectory.resolve("textures");
        Path terrainTexture = textureDir.resolve("terrain_texture.json");
        if (!Files.exists(terrainTexture, new LinkOption[0])) {
            BedrockPackLoader.sendError("Missing textures/terrain_texture.json");
            return null;
        }
        try {
            JsonObject terrainTextureObj = (JsonObject)GSON.fromJson(Files.readString(terrainTexture), JsonObject.class);
            JsonObject textureData = terrainTextureObj.getAsJsonObject("texture_data");
            HashMap<String, byte[]> textures = new HashMap<String, byte[]>();
            for (Map.Entry entry : textureData.entrySet()) {
                JsonObject data;
                JsonElement texturesElement;
                if (!((JsonElement)entry.getValue()).isJsonObject() || !(texturesElement = (data = ((JsonElement)entry.getValue()).getAsJsonObject()).get("textures")).isJsonPrimitive()) continue;
                Path texturePath = resourcePackDirectory.resolve(texturesElement.getAsString() + ".png");
                textures.put((String)entry.getKey(), Files.readAllBytes(texturePath));
            }
            return textures;
        }
        catch (IOException e) {
            BedrockPackLoader.sendError(e.toString());
            return null;
        }
    }

    private static void sendError(String error2) {
        class_310.method_1551().field_1724.method_43496((class_2561)class_2561.method_43470((String)error2).method_27692(class_124.field_1061));
    }

    private static void sendSuccess(String error2) {
        class_310.method_1551().field_1724.method_43496((class_2561)class_2561.method_43470((String)error2).method_27692(class_124.field_1060));
    }
}

